/**
 * Copyright (c) 2010 Himanshu Chauhan.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * @file vmm_macros.h
 * @author Himanshu Chauhan (hschauhan@nulltrace.org)
 * @brief Useful preprocessor macros for vmm
 */

#ifndef __VMM_MACROS_H__
#define __VMM_MACROS_H__

#define offsetof(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)

#define container_of(ptr, type, member) ({			\
	const typeof(((type *)0)->member) * __mptr = (ptr);	\
	(type *)((char *)__mptr - offsetof(type, member)); })

#define array_size(x) (sizeof(x) / sizeof((x)[0]))

#define field_sizeof(t, f) (sizeof(((t*)0)->f))

#define min(a, b) ((a) < (b) ? (a) : (b))

#define max(a, b) ((a) < (b) ? (b) : (a))

/* Help in branch prediction */
#define likely(x) __builtin_expect((x), 1)

#define unlikely(x) __builtin_expect((x), 0)

#endif /* __VMM_MACROS_H__ */
